clear all;
close all;

% Define the parent directory and output directory
input_base_dir = '\\csunas01.colostate.edu\research\METEC\User\mbua\ADED\Eddy Covariance\8_Hz\Event Tables\Emission Sources\Multi_Point\Emission Point';
output_base_dir = 'C:\Users\mbua\Desktop\ADED\Eddy Covariance\Multi_Point';

% Specify the folders to process
time_intervals = {'5 minutes', '15 minutes', '30 minutes'};
degree_folders = {'10 degrees', '20 degrees', '45 degrees'}; % Explicitly specify degree folders

% Columns to keep in output files
selected_columns = {'U', 'V', 'W', 'AT', 'BP', 'x_CH4_d_ppm'};

% Loop through each time interval folder
for t = 1:numel(time_intervals)
    time_folder = time_intervals{t};
    time_path = fullfile(input_base_dir, time_folder);
    
    % Loop through each degree folder (only process specified ones)
    for d = 1:numel(degree_folders)
        degree_folder = degree_folders{d};
        degree_path = fullfile(time_path, degree_folder);
        
        % Check if the degree folder exists
        if ~exist(degree_path, 'dir')
            warning('Degree folder not found: %s', degree_path);
            continue;
        end
        
        % Get list of CSV files in the current degree folder
        file_list = dir(fullfile(degree_path, '*.csv'));
        
        % Create corresponding output folder structure
        output_folder = fullfile(output_base_dir, time_folder, degree_folder, 'EddyPro Input');
        if ~exist(output_folder, 'dir')
            mkdir(output_folder);
        end
        
        % Process each CSV file
        for f = 1:numel(file_list)
            input_file = fullfile(file_list(f).folder, file_list(f).name);
            
            try
                % Read the input file
                data = readtable(input_file);
                
                % Verify required columns exist
                if ~all(ismember(selected_columns, data.Properties.VariableNames))
                    missing_cols = setdiff(selected_columns, data.Properties.VariableNames);
                    warning('File %s missing columns: %s. Skipping...', ...
                           file_list(f).name, strjoin(missing_cols, ', '));
                    continue;
                end
                
                % Select only the desired columns
                selected_data = data(:, selected_columns);
                
                % Parse the input filename to create output filename
                [~, basename, ~] = fileparts(file_list(f).name);
                
                % Extract components from filename (format: "YYYY-MM-DD HH-MM-SS_to_YYYY-MM-DD HH-MM-SS_ID")
                tokens = split(basename, {' ', '_', '-', 'to'});
                tokens(cellfun(@isempty, tokens)) = []; % Remove empty tokens
                
                if numel(tokens) < 9
                    warning('Invalid filename format: %s. Expected "YYYY-MM-DD HH-MM-SS_to_YYYY-MM-DD HH-MM-SS_ID"', ...
                           file_list(f).name);
                    continue;
                end
                
                % Construct output filename: YYYY-MM-DD_HHMM_ID.txt
                output_name = sprintf('%s-%s-%s_%s%s_%s', ...
                                    tokens{1}, tokens{2}, tokens{3}, ... % YYYY-MM-DD
                                    tokens{4}, tokens{5}, ...            % HHMM
                                    tokens{end});                       % ID
                
                % Write to output file
                output_file = fullfile(output_folder, [output_name, '.txt']);
                writetable(selected_data, output_file, 'Delimiter', ',');
                
            catch ME
                warning('Error processing file %s: %s', file_list(f).name, ME.message);
                continue;
            end
        end
    end
end

disp('Processing complete. Files saved in EddyPro Input folders.');